import { useEffect } from 'react'
import { useRouter } from 'next/navigation'
import { useAuth } from '@/components/auth/ClientAuthProvider'

export function useAdminRedirect() {
  const { user, profile, loading } = useAuth()
  const router = useRouter()

  useEffect(() => {
    // Only run when auth is loaded and user is logged in
    if (!loading && user && profile) {
      // If user is admin and not on admin page, redirect to admin
      if (profile.is_admin && !window.location.pathname.startsWith('/admin')) {
        console.log('[useAdminRedirect] Admin user detected, redirecting to admin dashboard')
        router.push('/admin')
      }
      // If user is not admin and on admin page, redirect to home
      else if (!profile.is_admin && window.location.pathname.startsWith('/admin')) {
        console.log('[useAdminRedirect] Non-admin user on admin page, redirecting to home')
        router.push('/')
      }
    }
  }, [user, profile, loading, router])

  return { user, profile, loading }
}