import { createServerSupabaseClient } from './supabase-server'

export async function initializeDatabase() {
  const supabase = await createServerSupabaseClient()
  
  try {
    // Check if profiles table exists by trying to query it
    const { error: profilesError } = await supabase
      .from('profiles')
      .select('id')
      .limit(1)
    
    if (profilesError) {
      console.log('❌ Database not initialized!')
      console.log('📋 Please follow these steps to set up your database:')
      console.log('   1. Go to your Supabase dashboard')
      console.log('   2. Navigate to SQL Editor')
      console.log('   3. Copy the contents of supabase-schema.sql')
      console.log('   4. Paste and run the SQL in the editor')
      console.log('   5. Refresh this page')
      return false
    } else {
      console.log('✅ Database is properly initialized!')
      return true
    }
  } catch (error) {
    console.error('❌ Error checking database:', error)
    console.log('📋 Please ensure your Supabase database is set up correctly.')
    return false
  }
}