// Environment validation utility

export function validateEnvironment() {
  const requiredEnvVars = [
    'NEXT_PUBLIC_SUPABASE_URL',
    'NEXT_PUBLIC_SUPABASE_ANON_KEY'
  ]

  const missing = requiredEnvVars.filter(key => {
    const value = process.env[key]
    return !value || value.includes('placeholder') || value.includes('your-')
  })

  if (missing.length > 0) {
    console.warn('⚠️  Missing or placeholder environment variables:')
    missing.forEach(key => {
      console.warn(`   - ${key}`)
    })
    console.warn('\n📖 Please set up your environment variables:')
    console.warn('   1. Copy .env.local and update with your Supabase credentials')
    console.warn('   2. See SETUP.md for detailed instructions')
    console.warn('\n🔗 Create a Supabase project at: https://supabase.com')
  }

  return missing.length === 0
}

export function isDevelopment() {
  return process.env.NODE_ENV === 'development'
}
