import { supabase } from './supabase-client'

export async function syncSessionWithServer() {
  try {
    // Get current session
    const { data: { session }, error } = await supabase.auth.getSession()
    
    if (error) {
      console.error('[SessionSync] Error getting session:', error)
      return false
    }
    
    if (!session) {
      console.log('[SessionSync] No session found')
      return false
    }
    
    console.log('[SessionSync] Session found, validating session')
    
    // Try to refresh the session to ensure it's valid and up-to-date
    const { data: refreshData, error: refreshError } = await supabase.auth.refreshSession()
    
    if (refreshError) {
      console.warn('[SessionSync] Session refresh failed, but session might still be valid:', refreshError)
      // Don't return false, the session might still be valid
      return true
    }
    
    if (!refreshData.session) {
      console.warn('[SessionSync] No session after refresh, but original session exists')
      // Don't return false, the original session might still be valid
      return true
    }
    
    console.log('[SessionSync] Session validated successfully')
    return true
  } catch (error) {
    console.warn('[SessionSync] Session validation error, but continuing:', error)
    // Don't return false, the session might still be valid
    return true
  }
}

export async function refreshSession() {
  try {
    const { data, error } = await supabase.auth.refreshSession()
    
    if (error) {
      console.error('[SessionSync] Error refreshing session:', error)
      return false
    }
    
    console.log('[SessionSync] Session refreshed successfully')
    return true
  } catch (error) {
    console.error('[SessionSync] Session refresh error:', error)
    return false
  }
}
