// Environment variables check utility
export function checkSupabaseEnv(): { isValid: boolean; message: string } {
  const url = process.env.NEXT_PUBLIC_SUPABASE_URL
  const key = process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY

  if (!url || !key) {
    return {
      isValid: false,
      message: 'Supabase environment variables not set. Please create a .env.local file with NEXT_PUBLIC_SUPABASE_URL and NEXT_PUBLIC_SUPABASE_ANON_KEY'
    }
  }

  if (!url.startsWith('https://')) {
    return {
      isValid: false,
      message: 'NEXT_PUBLIC_SUPABASE_URL should start with https://'
    }
  }

  if (key.length < 20) {
    return {
      isValid: false,
      message: 'NEXT_PUBLIC_SUPABASE_ANON_KEY appears to be invalid (too short)'
    }
  }

  return {
    isValid: true,
    message: 'Environment variables are properly configured'
  }
}

export function logEnvStatus(): void {
  const envCheck = checkSupabaseEnv()
  
  if (envCheck.isValid) {
    console.log('✅ Supabase environment variables are properly configured')
  } else {
    console.warn('⚠️ Supabase environment variables issue:', envCheck.message)
  }
}

