// Utility to get client IP address
export async function getClientIP(): Promise<string> {
  try {
    // Try to get IP from a public service
    const response = await fetch('https://api.ipify.org?format=json', {
      method: 'GET',
      headers: {
        'User-Agent': 'BetFusion-Zim/1.0'
      }
    })
    
    if (response.ok) {
      const data = await response.json()
      return data.ip || 'Unknown'
    }
  } catch (error) {
    console.warn('Failed to get client IP:', error)
  }
  
  return 'Unknown'
}

