// Test script to verify admin markets functionality
const { createClient } = require('@supabase/supabase-js')

// Use your Supabase credentials
const supabaseUrl = 'https://myrocyiwjvkdpxfpnuyc.supabase.co'
const supabaseKey = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6Im15cm9jeWl3anZrZHB4ZnBudXljIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NjAzNjA3OTAsImV4cCI6MjA3NTkzNjc5MH0.soVAUiwBOM2jipWwTFtq5LZi5NrGomDSlZTdJqNZm4'

const supabase = createClient(supabaseUrl, supabaseKey)

async function testAdminMarkets() {
  console.log('🧪 Testing admin markets functionality...')
  
  try {
    // Test 1: Check if markets table exists
    console.log('\n1. Testing markets table access...')
    const { data: testData, error: testError } = await supabase
      .from('markets')
      .select('id, title, status')
      .limit(1)
    
    if (testError) {
      console.error('❌ Markets table test failed:', testError)
      return
    }
    
    console.log('✅ Markets table accessible')
    console.log('Sample market:', testData?.[0] || 'No markets found')
    
    // Test 2: Fetch all markets
    console.log('\n2. Fetching all markets...')
    const { data: markets, error: marketsError } = await supabase
      .from('markets')
      .select(`
        id,
        title,
        description,
        status,
        outcome,
        end_date,
        total_volume,
        yes_price,
        no_price,
        creator_id,
        creator_earnings,
        admin_fee,
        created_at,
        resolved_at
      `)
      .order('created_at', { ascending: false })
      .limit(10)
    
    if (marketsError) {
      console.error('❌ Error fetching markets:', marketsError)
      return
    }
    
    console.log(`✅ Found ${markets.length} markets`)
    
    // Test 3: Calculate metrics
    console.log('\n3. Calculating metrics...')
    const totalMarkets = markets.length
    const activeMarkets = markets.filter(m => m.status === 'active').length
    const resolvedMarkets = markets.filter(m => m.status === 'resolved').length
    const totalVolume = markets.reduce((sum, m) => sum + (m.total_volume || 0), 0)
    const totalEarnings = markets.reduce((sum, m) => sum + (m.creator_earnings || 0) + (m.admin_fee || 0), 0)
    
    console.log('📊 Market Metrics:')
    console.log(`  Total Markets: ${totalMarkets}`)
    console.log(`  Active Markets: ${activeMarkets}`)
    console.log(`  Resolved Markets: ${resolvedMarkets}`)
    console.log(`  Total Volume: $${totalVolume.toLocaleString()}`)
    console.log(`  Total Earnings: $${totalEarnings.toLocaleString()}`)
    
    // Test 4: Show sample markets
    console.log('\n4. Sample Markets:')
    markets.slice(0, 3).forEach((market, index) => {
      console.log(`\n  Market ${index + 1}:`)
      console.log(`    Title: ${market.title}`)
      console.log(`    Status: ${market.status}`)
      console.log(`    Volume: $${market.total_volume || 0}`)
      console.log(`    Prices: YES ${((market.yes_price || 0) * 100).toFixed(1)}% • NO ${((market.no_price || 0) * 100).toFixed(1)}%`)
      console.log(`    Created: ${new Date(market.created_at).toLocaleDateString()}`)
    })
    
    // Test 5: Check for Zimbabwe markets
    console.log('\n5. Checking for Zimbabwe markets...')
    const zimbabweMarkets = markets.filter(m => 
      m.title.toLowerCase().includes('zimbabwe') || 
      m.title.toLowerCase().includes('zim')
    )
    
    console.log(`✅ Found ${zimbabweMarkets.length} Zimbabwe-related markets`)
    
    if (zimbabweMarkets.length > 0) {
      console.log('\n🇿🇼 Zimbabwe Markets:')
      zimbabweMarkets.forEach((market, index) => {
        console.log(`  ${index + 1}. ${market.title}`)
        console.log(`     Status: ${market.status} | Volume: $${market.total_volume || 0}`)
      })
    }
    
    console.log('\n🎉 Admin markets test completed successfully!')
    console.log('\nNext steps:')
    console.log('1. Visit /admin/markets in your application')
    console.log('2. Check that markets are loading properly')
    console.log('3. Test search and filtering functionality')
    console.log('4. Verify market management actions work')
    
  } catch (error) {
    console.error('❌ Test failed:', error)
  }
}

// Run the test
testAdminMarkets()
