// Test PayNow integration using the official library
const { Paynow } = require('paynow')

async function testPayNowIntegration() {
  console.log('🧪 Testing PayNow Integration...')
  
  try {
    // Create PayNow instance (use your actual credentials)
    const paynow = new Paynow(
      process.env.PAYNOW_ZIM_INTEGRATION_ID || 'your_integration_id',
      process.env.PAYNOW_ZIM_INTEGRATION_KEY || 'your_integration_key'
    )
    
    // Set URLs
    paynow.resultUrl = 'http://localhost:3000/api/webhooks/paynow-zim'
    paynow.returnUrl = 'http://localhost:3000/wallet?deposit=success'
    
    // Create a test payment
    const payment = paynow.createPayment('test_payment_123', 'test@example.com')
    payment.add('Test Deposit', 10.00)
    
    console.log('✅ PayNow instance created successfully')
    console.log('✅ Payment object created successfully')
    
    // Note: Don't actually send the payment in test mode
    console.log('⚠️  Skipping actual payment send (use real credentials for testing)')
    
    console.log('🎉 PayNow integration test completed successfully!')
    
  } catch (error) {
    console.error('❌ PayNow integration test failed:', error.message)
  }
}

// Run the test
testPayNowIntegration()
