# Share Information Update Test

## How to Test Share Information Updates

### 1. **Open Market Detail Page**
- Navigate to any market (binary or multi-outcome)
- Open the betting form

### 2. **Test Binary Market Updates**
- Select "YES" or "NO" outcome
- Enter an amount (e.g., $100)
- Check console for debug logs showing price updates
- Verify share information shows current price and calculated shares

### 3. **Test Multi-Outcome Market Updates**
- Select any outcome (e.g., "Candidate A")
- Enter an amount (e.g., $100)
- Check console for debug logs showing:
  - `selectedOutcome`: The chosen outcome name
  - `currentPrice`: Current price of the outcome
  - `shares`: Calculated shares based on amount/price
  - `marketType`: Should be 'multi_outcome'
  - `hasMarketOutcomes`: Should be true if live data is available
  - `hasLocalOutcomes`: Should be true if local data is available

### 4. **Expected Behavior**
- **Share information should update** when:
  - User changes outcome selection
  - User changes bet amount
  - Market prices change (live updates)
  - Market data refreshes

### 5. **Visual Indicators**
- **Live indicator**: Green pulsing dot with "Live" text
- **Current Price**: Blue text showing current outcome price
- **Your Shares**: Green text showing calculated shares
- **Payout Info**: Blue box showing potential payout

### 6. **Debug Information**
Check browser console for logs like:
```
Share calculation updated: {
  selectedOutcome: "Candidate A",
  currentPrice: 0.25,
  shares: "400.00",
  marketType: "multi_outcome",
  hasMarketOutcomes: true,
  hasLocalOutcomes: true
}
```

## Troubleshooting

### If Share Information Doesn't Update:

1. **Check Console Logs**
   - Look for debug logs showing price calculations
   - Verify `hasMarketOutcomes` or `hasLocalOutcomes` is true

2. **Check Market Data**
   - Ensure market has `outcomes` array for multi-outcome markets
   - Ensure market has `yes_price`/`no_price` for binary markets

3. **Check Live Updates**
   - Verify `useLiveMarketUpdates` is working
   - Check if market data is being updated in real-time

4. **Check Outcome Selection**
   - Ensure `selectedOutcome` is set correctly
   - Verify outcome exists in market data

## Expected Results

✅ **Share information updates in real-time**
✅ **Prices reflect current market conditions**
✅ **Shares calculated correctly based on amount/price**
✅ **Visual indicators show live status**
✅ **Debug logs show calculation updates**
